/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Tok;
import cds.tools.Util;
import java.util.ArrayList;
import java.util.Collections;

public class StatPixels {
    private static final int MAX = 100000;
    int nb;
    double sum;
    double sigma;
    double min;
    double max;
    double median;
    double surface;
    private boolean computed;
    private String cle;
    private ArrayList<Pixel> pixels;
    private long time;
    private long t;
    private boolean withLimit;
    private static int STATSUM = 1;
    private static int STATMIN = 2;
    private static int STATMAX = 4;
    private static int STATAREA = 8;
    private static int STATSIGMA = 16;
    private static int STATMEDIAN = 32;
    private static String[] STATLABEL = new String[]{"none", "sum", "min", "max", "area", "sigma", "median"};
    private static int[] STATMASK = new int[]{0, STATSUM, STATMIN, STATMAX, STATAREA, STATSIGMA, STATMEDIAN};
    private static int STATDEFAULT;
    private static int currentStatMask;

    public static void setStatMask(String s) throws Exception {
        if (s == null) {
            return;
        }
        Tok tok = new Tok(s, ",; ");
        while (tok.hasMoreTokens()) {
            int n;
            String k = tok.nextToken();
            if (k.length() == 0) continue;
            int c = k.charAt(0);
            String s1 = k.toLowerCase();
            if (c == 43 || c == 45) {
                s1 = k.substring(1).toLowerCase();
            } else {
                c = 32;
            }
            for (n = 0; n < STATLABEL.length && STATLABEL[n].toLowerCase().indexOf(s1) < 0; ++n) {
            }
            if (n == STATLABEL.length) {
                if (s1.equals("pixels")) {
                    System.err.println("Obsoleted stat mask [" + s1 + "] => ignored");
                    continue;
                }
                throw new Exception("Unknown stat label [" + k + "]");
            }
            if (c == 43) {
                currentStatMask |= STATMASK[n];
                continue;
            }
            if (c == 45) {
                currentStatMask &= ~STATMASK[n];
                continue;
            }
            currentStatMask = STATMASK[n];
        }
    }

    public static void setStatMask(int mask) {
    }

    public static String getStatMask() {
        StringBuilder s = new StringBuilder(100);
        for (int i = 1; i < STATLABEL.length; ++i) {
            if ((STATMASK[i] & currentStatMask) == 0) continue;
            if (s.length() > 0) {
                s.append(',');
            }
            s.append(STATLABEL[i]);
        }
        return s.toString();
    }

    protected boolean reinit() {
        return this.reinit(null);
    }

    protected boolean reinit(String cle) {
        return this.reinit(cle, false);
    }

    protected boolean reinit(String cle, boolean withLimit) {
        if (this.hasSameCle(cle)) {
            return false;
        }
        this.withLimit = withLimit;
        this.cle = cle;
        this.pixels = new ArrayList(100000);
        this.nb = 0;
        this.sum = Double.NaN;
        this.min = Double.NaN;
        this.max = Double.NaN;
        this.sigma = Double.NaN;
        this.median = Double.NaN;
        this.surface = Double.NaN;
        this.computed = false;
        this.t = Util.getTime();
        return true;
    }

    protected long getTime() {
        return this.time;
    }

    protected double[] getStatistics() {
        return this.getStatistics(false);
    }

    protected double[] getStatistics(boolean withMedian) {
        this.compute(withMedian);
        return new double[]{this.nb, this.sum, this.sigma, this.surface, this.min, this.max, this.median};
    }

    protected double[] getStatisticsRaDecPix() throws Exception {
        double[] res = new double[this.pixels.size() * 3];
        int i = 0;
        for (Pixel pix : this.pixels) {
            res[i++] = pix.raj;
            res[i++] = pix.dej;
            res[i++] = pix.val;
        }
        return res;
    }

    protected double[] getStatisticPix() {
        double[] res = new double[this.pixels.size()];
        int i = 0;
        for (Pixel pix : this.pixels) {
            res[i++] = pix.val;
        }
        return res;
    }

    protected boolean hasSameCle(String cle) {
        return this.cle != null && this.cle.equals(cle);
    }

    protected int addPix(double raj, double dej, double val) {
        int n = this.pixels.size();
        if (this.withLimit && n >= 100000) {
            return n;
        }
        this.pixels.add(new Pixel(raj, dej, val));
        return n + 1;
    }

    protected void setSurface(double surface) {
        this.surface = surface;
    }

    private boolean compute(boolean withMedian) {
        if (this.pixels == null || this.pixels.size() == 0) {
            return false;
        }
        if (this.computed) {
            return false;
        }
        boolean flagMin = (currentStatMask & STATMIN) != 0;
        boolean flagMax = (currentStatMask & STATMAX) != 0;
        boolean flagSigma = (currentStatMask & STATSIGMA) != 0;
        boolean flagSum = (currentStatMask & STATSUM) != 0;
        boolean flagMedian = (currentStatMask & STATMEDIAN) != 0 || withMedian;
        this.time = Util.getTime() - this.t;
        double sqr = 0.0;
        for (Pixel pix : this.pixels) {
            if (Double.isNaN(pix.val)) continue;
            ++this.nb;
            if (flagSum || flagSigma) {
                if (Double.isNaN(this.sum)) {
                    this.sum = 0.0;
                }
                this.sum += pix.val;
            }
            if (flagMin && (Double.isNaN(this.min) || pix.val < this.min)) {
                this.min = pix.val;
            }
            if (flagMax && (Double.isNaN(this.max) || pix.val > this.max)) {
                this.max = pix.val;
            }
            if (!flagSigma) continue;
            sqr += pix.val * pix.val;
        }
        if (flagSigma) {
            double mean = this.sum / (double)this.nb;
            double variance = sqr / (double)this.nb - mean * mean;
            this.sigma = Math.sqrt(variance);
        }
        if (flagMedian) {
            try {
                Collections.sort(this.pixels);
                this.median = this.pixels.get((int)(this.nb / 2)).val;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.computed = true;
        return true;
    }

    static {
        currentStatMask = STATDEFAULT = STATSUM | STATMIN | STATMAX | STATAREA | STATSIGMA;
    }

    class Pixel
    implements Comparable<Pixel> {
        double raj;
        double dej;
        double val;

        Pixel(double raj, double dej, double val) {
            this.raj = raj;
            this.dej = dej;
            this.val = val;
        }

        @Override
        public int compareTo(Pixel o) {
            return o.val == this.val ? 0 : (o.val < this.val ? 1 : -1);
        }
    }
}

